import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:infested_sand', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:brush') {
                const chance = Math.random()
                if (chance < 0.85 && selectedItem?.typeId === 'minecraft:brush') {
                    block.setType('minecraft:sand')
                    block.dimension.playSound('brush_completed.suspicious_sand', block.location)
                }
                else {
                    block.dimension.runCommand(`summon v360:woodlouse ${x} ${y + 1} ${z} ~~ minecraft:spawn_emerging`)
                    block.setType('minecraft:sand')
                    block.dimension.playSound('brush_completed.suspicious_sand', block.location)
                }
            }
        }
    })
})